\NeedsTeXFormat{pLaTeX2e}
\ProvidesClass{jima-paper}
%  [2000/06/27 ver2.0 base on jarticle.cls and jsize10.clo]
%  [2005/01/25 v1.0 for Transactions of JIMA]
%%% O()
%%% {ocHw
%  [2009/05/16 v2.0 for Transactions of JIMA]
%  [2009/07/24 v2.1 for Transactions of JIMA]
  [2010/04/07 v2.2 for Transactions of JIMA]
%%% ܓoRqC֗f

\newcounter{@paper}
\newif\if@landscape \@landscapefalse
\newcommand{\@ptsize}{}
\newif\if@Proof
\newif\if@restonecol
\newif\if@titlepage
\@titlepagefalse
\hour\time \divide\hour by 60\relax
\@tempcnta\hour \multiply\@tempcnta 60\relax
\minute\time \advance\minute-\@tempcnta
\newif\if@stysize \@stysizefalse
\newif\if@enablejfam \@enablejfamtrue
%\DeclareOption{a4paper}{\setcounter{@paper}{1}%
%  \setlength\paperheight {297mm}%
%  \setlength\paperwidth  {210mm}}
%\DeclareOption{a5paper}{\setcounter{@paper}{2}%
%  \setlength\paperheight {210mm}
%  \setlength\paperwidth  {148mm}}
%\DeclareOption{b4paper}{\setcounter{@paper}{3}%
%  \setlength\paperheight {364mm}
%  \setlength\paperwidth  {257mm}}
\DeclareOption{b5paper}{\setcounter{@paper}{4}%
  \setlength\paperheight {257mm}
  \setlength\paperwidth  {182mm}}
%\DeclareOption{a4j}{\setcounter{@paper}{1}\@stysizetrue
%  \setlength\paperheight {297mm}%
%  \setlength\paperwidth  {210mm}}
%\DeclareOption{a5j}{\setcounter{@paper}{2}\@stysizetrue
%  \setlength\paperheight {210mm}
%  \setlength\paperwidth  {148mm}}
%\DeclareOption{b4j}{\setcounter{@paper}{3}\@stysizetrue
%  \setlength\paperheight {364mm}
%  \setlength\paperwidth  {257mm}}
\DeclareOption{b5j}{\setcounter{@paper}{4}\@stysizetrue
  \setlength\paperheight {257mm}
  \setlength\paperwidth  {182mm}}
%\DeclareOption{a4p}{\setcounter{@paper}{1}\@stysizetrue
%  \setlength\paperheight {297mm}%
%  \setlength\paperwidth  {210mm}}
%\DeclareOption{a5p}{\setcounter{@paper}{2}\@stysizetrue
%  \setlength\paperheight {210mm}
%  \setlength\paperwidth  {148mm}}
%\DeclareOption{b4p}{\setcounter{@paper}{3}\@stysizetrue
%  \setlength\paperheight {364mm}
%  \setlength\paperwidth  {257mm}}
%\DeclareOption{b5p}{\setcounter{@paper}{4}\@stysizetrue
%  \setlength\paperheight {257mm}
%  \setlength\paperwidth  {182mm}}
\if@compatibility
  \renewcommand{\@ptsize}{0}
\else
  \DeclareOption{10pt}{\renewcommand{\@ptsize}{0}}
\fi
\DeclareOption{11pt}{\renewcommand{\@ptsize}{1}}
\DeclareOption{12pt}{\renewcommand{\@ptsize}{2}}
\DeclareOption{landscape}{\@landscapetrue
  \setlength\@tempdima{\paperheight}%
  \setlength\paperheight{\paperwidth}%
  \setlength\paperwidth{\@tempdima}}
\DeclareOption{tombow}{%
  \tombowtrue \tombowdatetrue
  \setlength{\@tombowwidth}{.1\p@}%
  \@bannertoken{%
     \jobname\space:\space\number\year/\number\month/\number\day
      (\number\hour:\number\minute)}
  \maketombowbox}
\DeclareOption{tombo}{%
  \tombowtrue \tombowdatefalse
  \setlength{\@tombowwidth}{.1\p@}%
  \maketombowbox}
\DeclareOption{mentuke}{%
  \tombowtrue
  \setlength{\@tombowwidth}{\z@}%
  \@bannertoken\@empty
  \maketombowbox}
\DeclareOption{tate}{%
  \AtBeginDocument{\tate\message{scg[ht}%
                   \adjustbaseline}%
}
\DeclareOption{oneside}{\@twosidefalse}
\DeclareOption{twoside}{\@twosidetrue}
\DeclareOption{onecolumn}{\@twocolumnfalse}
\DeclareOption{twocolumn}{\@twocolumntrue}
\DeclareOption{titlepage}{\@titlepagetrue}
\DeclareOption{notitlepage}{\@titlepagefalse}
\DeclareOption{Proof}{\@Prooftrue}
\DeclareOption{leqno}{\input{leqno.clo}}
\DeclareOption{fleqn}{\input{fleqn.clo}}
\DeclareOption{openbib}{%
  \AtEndOfPackage{%
   \renewcommand\@openbib@code{%
      \advance\leftmargin\bibindent
      \itemindent -\bibindent
      \listparindent \itemindent
      \parsep \z@
      }%
   \renewcommand\newblock{\par}}}
\if@compatibility
\else
  \DeclareOption{disablejfam}{\@enablejfamfalse}
\fi
\DeclareOption{draft}{\setlength\overfullrule{5pt}}
\DeclareOption{final}{\setlength\overfullrule{0pt}}
%%%\ExecuteOptions{a4paper,10pt,oneside,onecolumn,final}
\ExecuteOptions{b5paper,twoside,twocolumn,final}
\ProcessOptions\relax

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\input{jsize1\@ptsize.clo}
%\NeedsTeXFormat{pLaTeX2e}
%\ProvidesFile{jsize10.clo}
%  [1998/04/07 v1.1m Standard pLaTeX file (size option)]


\newdimen\h
  \h=0.25mm
\newdimen\JQ % for SK fonts
  \JQ=0.7392507pt
\newdimen\Q % for SE fonts
  \Q=0.71144pt
\newdimen\@bs
  \@bs=18\h

 \DeclareFontShape{JY1}{mc}{m}{n}{<5> sgen*min
 <6> s * [1.10888] min6      %  9  scriptsize
 <7> s * [1.05607] min7      % 10  footnotesize and Footnotesize
 <8> s * [1.01647] min8      % 11  small
 <9> s * [0.98567] min9      % 12  normalsize
 <10> s * [0.96103] min10    % 13  large
 <10.95> s * [1.08018] min10 % 16  Large
 <12> s * [0.98567] min10    % 16  LARGE
 <14.4> s * [1.02674] min10  % 20  huge and Huge
 <17.28> s * [1.02674] min10 % 24  
 <20.74> s * [0.99802] min10 % 28  
 <24.88> s * [1.12908] min10 % 38  
 <-> min10
 }{}
 \DeclareFontShape{JY1}{mc}{bx}{n}{<5> sgen*goth
 <6> s * [1.10888] goth6      %  9  scriptsize
 <7> s * [1.05607] goth7      % 10  footnotesize and Footnotesize
 <8> s * [1.01647] goth8      % 11  small
 <9> s * [0.98567] goth9      % 12  normalsize
 <10> s * [0.96103] goth10    % 13  large
 <10.95> s * [1.08018] goth10 % 16  Large
 <12> s * [0.98567] goth10    % 16  LARGE
 <14.4> s * [1.02674] goth10  % 20  huge and Huge
 <17.28> s * [1.02674] goth10 % 24  
 <20.74> s * [0.99802] goth10 % 28  
 <24.88> s * [1.12908] goth10 % 38  
 <-> goth10
 }{}
%
 \DeclareFontShape{JY1}{gt}{m}{n}{<5> sgen*goth
 <6> s * [1.10888] goth6      %  9  scriptsize
 <7> s * [1.05607] goth7      % 10  footnotesize and Footnotesize
 <8> s * [1.01647] goth8      % 11  small
 <9> s * [0.98567] goth9      % 12  normalsize
 <10> s * [0.96103] goth10    % 13  large
 <10.95> s * [1.08018] goth10 % 16  Large
 <12> s * [0.98567] goth10    % 16  LARGE
 <14.4> s * [1.02674] goth10  % 20  huge and Huge
 <17.28> s * [1.02674] goth10 % 24  
 <20.74> s * [0.99802] goth10 % 28  
 <24.88> s * [1.12908] goth10 % 38  
 <-> goth10
 }{}
 \DeclareFontShape{JY1}{gt}{bx}{n}{<5> sgen*goth
 <6> s * [1.10888] goth6      %  9  scriptsize
 <7> s * [1.05607] goth7      % 10  footnotesize and Footnotesize
 <8> s * [1.01647] goth8      % 11  small
 <9> s * [0.98567] goth9      % 12  normalsize
 <10> s * [0.96103] goth10    % 13  large
 <10.95> s * [1.08018] goth10 % 16  Large
 <12> s * [0.98567] goth10    % 16  LARGE
 <14.4> s * [1.02674] goth10  % 20  huge and Huge
 <17.28> s * [1.02674] goth10 % 24  
 <20.74> s * [0.99802] goth10 % 28  
 <24.88> s * [1.12908] goth10 % 38  
 <-> goth10
 }{}
%
% \DeclarePreloadSizes{JY1}{mc}{m}{n}
%   {5,6,7,8,9,10,10.95,12,14.4,17.28,20.74,24.88}
% \DeclarePreloadSizes{JY1}{gt}{m}{n}
%   {5,6,7,8,9,10,10.95,12,14.4,17.28,20.74,24.88}

%%% from ieice.cls(uls)
 %% JY1 it
 \DeclareFontShape{JY1}{mc}{m}{it}{<->ssub*mc/m/n}{}
 \DeclareFontShape{JY1}{mc}{bx}{it}{<->ssub*gt/m/n}{}
 \DeclareFontShape{JY1}{gt}{m}{it}{<->ssub*gt/m/n}{}
 \DeclareFontShape{JY1}{gt}{bx}{it}{<->ssub*gt/m/n}{}
 %%
 \DeclareFontShape{JY1}{mc}{b}{it}{<->ssub*mc/m/n}{}
 \DeclareFontShape{JY1}{mc}{eb}{it}{<->ssub*mc/m/n}{}
 \DeclareFontShape{JY1}{gt}{b}{it}{<->ssub*mc/m/n}{}
 \DeclareFontShape{JY1}{gt}{eb}{it}{<->ssub*mc/m/n}{}
 \DeclareFontShape{JY1}{gt}{ub}{it}{<->ssub*mc/m/n}{}
 %% JT1 it
 \DeclareFontShape{JT1}{mc}{m}{it}{<->ssub*mc/m/n}{}
 \DeclareFontShape{JT1}{mc}{bx}{it}{<->ssub*gt/m/n}{}
 \DeclareFontShape{JT1}{gt}{m}{it}{<->ssub*gt/m/n}{}
 \DeclareFontShape{JT1}{gt}{bx}{it}{<->ssub*gt/m/n}{}
 %%
 \DeclareFontShape{JT1}{mc}{b}{it}{<->ssub*mc/m/n}{}
 \DeclareFontShape{JT1}{mc}{eb}{it}{<->ssub*mc/m/n}{}
 \DeclareFontShape{JT1}{gt}{b}{it}{<->ssub*mc/m/n}{}
 \DeclareFontShape{JT1}{gt}{eb}{it}{<->ssub*mc/m/n}{}
 \DeclareFontShape{JT1}{gt}{ub}{it}{<->ssub*mc/m/n}{}
 %% sc
 \DeclareFontShape{JY1}{mc}{m}{sc}{<->ssub*mc/m/n}{}
 \DeclareFontShape{JT1}{mc}{m}{sc}{<->ssub*mc/m/n}{}


  \font\EFnomble=cmbx10 at 12\Q
  \font\EFhead=cmbx10 at 12\Q
  \font\EFrmhead=cmr10 at 12\Q
  \font\KFhead=goth10 at 12\JQ
  \font\KFauthor=min10 at 15\JQ
  \font\KFronbun=goth10 at 15\JQ
  \font\Originalsl=cmsl10 at 14\Q
  \font\Abstrm=cmr10 at 15\Q
  \font\sixtymin = min10 at 16\JQ


%%% normalsize -->9pt 12Q 18h
\renewcommand{\normalsize}{%
    \@setfontsize\normalsize\@ixpt{18\h}%
  \abovedisplayskip 9\p@ \@plus2\p@ \@minus5\p@
  \abovedisplayshortskip \z@ \@plus3\p@
  \belowdisplayshortskip 6\p@ \@plus3\p@ \@minus3\p@
   \belowdisplayskip \abovedisplayskip
   \let\@listi\@listI}
\normalsize
\setbox0\hbox{\char\euc"A1A1}%
\setlength\Cht{\ht0}
\setlength\Cdp{\dp0}
\setlength\Cwd{\wd0}
\setlength\Cvs{\baselineskip}
\setlength\Chs{\wd0}

%%% small-->8pt 11Q 16h
\newcommand{\small}{%
  \@setfontsize\small\@viiipt{16\h}%
  \abovedisplayskip 8.5\p@ \@plus3\p@ \@minus4\p@
  \abovedisplayshortskip \z@ \@plus2\p@
  \belowdisplayshortskip 4\p@ \@plus2\p@ \@minus2\p@
  \def\@listi{\leftmargin\leftmargini
              \topsep 4\p@ \@plus2\p@ \@minus2\p@
              \parsep 2\p@ \@plus\p@ \@minus\p@
              \itemsep \parsep}%
  \belowdisplayskip \abovedisplayskip}

%%% footnotesize-->7pt 10Q 14h
\newcommand{\footnotesize}{%
  \@setfontsize\footnotesize\@viipt{14\h}%
  \abovedisplayskip 6\p@ \@plus2\p@ \@minus4\p@
  \abovedisplayshortskip \z@ \@plus\p@
  \belowdisplayshortskip 3\p@ \@plus\p@ \@minus2\p@
  \def\@listi{\leftmargin\leftmargini
              \topsep 3\p@ \@plus\p@ \@minus\p@
              \parsep 2\p@ \@plus\p@ \@minus\p@
              \itemsep \parsep}%
  \belowdisplayskip \abovedisplayskip}

%%% Footnotesize-->7pt 10Q 15h  for table
\newcommand{\Footnotesize}{%
  \@setfontsize\Footnotesize\@viipt{15\h}%
  \abovedisplayskip 6\p@ \@plus2\p@ \@minus4\p@
  \abovedisplayshortskip \z@ \@plus\p@
  \belowdisplayshortskip 3\p@ \@plus\p@ \@minus2\p@
  \def\@listi{\leftmargin\leftmargini
              \topsep 3\p@ \@plus\p@ \@minus\p@
              \parsep 2\p@ \@plus\p@ \@minus\p@
              \itemsep \parsep}%
  \belowdisplayskip \abovedisplayskip}

\newcommand{\scriptsize}{\@setfontsize\scriptsize\@vipt{12\h}}
\newcommand{\tiny}{\@setfontsize\tiny\@vpt{10\h}}
\newcommand{\large}{\@setfontsize\large\@xpt{16\h}}%10pt 13Q 16h
%\newcommand{\largefoot}{\@setfontsize\large\@xpt{16\h}}%10pt 13Q 16h
\newcommand{\Large}{\@setfontsize\Large\@xipt{24\h}}%11pt 16Q 24h
\newcommand{\LARGE}{\@setfontsize\LARGE\@xiipt{22\h}}%12pt 16Q 22h
\newcommand{\huge}{\@setfontsize\huge\@xivpt{25\h}}%14pt 20Q 25h
\newcommand{\Huge}{\@setfontsize\Huge\@xivpt{32\h}}%14pt 20Q 32h


\setlength\headheight{0mm}
\setlength\headsep{0mm}
\setlength\topskip{1\Cht}
\setlength\footskip{8mm}
\setlength\maxdepth{.5\topskip}

\hoffset=-10mm
%\voffset=15mm

\baselineskip=18\h
\setlength\textwidth{150mm}%12zw~24~2column=144mm, 144+24\h(6mm)=150mm
\@settopoint\textwidth
\setlength\textheight{46\baselineskip}%% 47 lines
 \advance \textheight \topskip
 \advance \textheight .3mm %% limit .275mm
\@settopoint\textheight

\setlength\marginparsep{10\p@}
\setlength\marginparpush{5\p@}


%tombow macro
\iftombow
% \hoffset\z@
% \voffset\z@
 \topmargin\paperheight
 \advance \topmargin -\textheight
 \advance \topmargin -\headheight
 \advance \topmargin -\headsep
 \advance \topmargin -\footskip
 \divide \topmargin \tw@
 \advance \topmargin 4mm %% adjustmsent
 \advance \topmargin -1in
 \@settopoint\topmargin
 \oddsidemargin\paperwidth
 \advance \oddsidemargin -\textwidth
 \divide \oddsidemargin \tw@
 \advance \oddsidemargin -1in
 \@settopoint\oddsidemargin
 \evensidemargin\oddsidemargin
 \@settopoint\evensidemargin
\else
 \topmargin\z@
 \@settopoint\topmargin
 \oddsidemargin\z@
 \@settopoint\oddsidemargin
 \evensidemargin\z@
 \@settopoint\evensidemargin
\fi

\marginparwidth 2in
\@settopoint\marginparwidth

\setlength\footnotesep{6.65\p@}
\setlength{\skip\footins}{9\p@ \@plus 4\p@ \@minus 2\p@}

\setlength\floatsep    {12\p@ \@plus 6\p@ \@minus 2\p@}
\setlength\textfloatsep{12\p@ \@plus 6\p@ \@minus 4\p@}
\setlength\intextsep   {12\p@ \@plus 6\p@ \@minus 2\p@}
%
\setlength\dblfloatsep    {12\p@ \@plus 6\p@ \@minus 2\p@}
\setlength\dbltextfloatsep{12\p@ \@plus 6\p@ \@minus 4\p@}
%
\setlength\@fptop{0\p@ \@plus 1fil}
\setlength\@fpsep{8\p@ \@plus 2fil}
\setlength\@fpbot{0\p@ \@plus 1fil}
\setlength\@dblfptop{0\p@ \@plus 1fil}
\setlength\@dblfpsep{8\p@ \@plus 2fil}
\setlength\@dblfpbot{0\p@ \@plus 1fil}

\setlength\partopsep{\z@ plus 0.1\@bs minus 0.1\@bs}

\def\@listI{\leftmargin\leftmargini \parsep \z@ plus 0.1\@bs minus 0.1\@bs
\topsep 1\@bs plus 0.1\@bs minus 0.1\@bs \itemsep \z@ plus 0.1\@bs minus 0.1\@bs}
\let\@listi\@listI
\@listi 
\def\@listii{\leftmargin\leftmarginii
 \labelwidth\leftmarginii\advance\labelwidth-\labelsep
 \labelsep 0.5zw
 \topsep \z@ plus 0.1\@bs minus 0.1\@bs
 \parsep \z@ plus 0.1\@bs minus 0.1\@bs
 \itemsep \parsep}
\def\@listiii{\leftmargin\leftmarginiii
 \labelwidth\leftmarginiii\advance\labelwidth-\labelsep
 \topsep \z@ plus 0.1\@bs minus 0.1\@bs
 \parsep \z@ \partopsep \z@ plus 0.1\@bs minus 0.1\@bs
 \itemsep \topsep}
\def\@listiv{\leftmargin\leftmarginiv
 \labelwidth\leftmarginiv\advance\labelwidth-\labelsep}
\def\@listv{\leftmargin\leftmarginv
 \labelwidth\leftmarginv\advance\labelwidth-\labelsep}
\def\@listvi{\leftmargin\leftmarginvi
 \labelwidth\leftmarginvi\advance\labelwidth-\labelsep}


%\def\@listi{\leftmargin\leftmargini
%  \parsep 4\p@ \@plus2\p@ \@minus\p@
%  \topsep 8\p@ \@plus2\p@ \@minus4\p@
%  \itemsep4\p@ \@plus2\p@ \@minus\p@}
%\let\@listI\@listi
%\@listi
%\def\@listii{\leftmargin\leftmarginii
%   \labelwidth\leftmarginii \advance\labelwidth-\labelsep
%   \topsep  4\p@ \@plus2\p@ \@minus\p@
%   \parsep  2\p@ \@plus\p@  \@minus\p@
%   \itemsep\parsep}
%\def\@listiii{\leftmargin\leftmarginiii
%   \labelwidth\leftmarginiii \advance\labelwidth-\labelsep
%   \topsep 2\p@  \@plus\p@\@minus\p@
%   \parsep\z@
%   \partopsep \p@ \@plus\z@ \@minus\p@
%   \itemsep\topsep}
%\def\@listiv {\leftmargin\leftmarginiv
%              \labelwidth\leftmarginiv
%              \advance\labelwidth-\labelsep}
%\def\@listv  {\leftmargin\leftmarginv
%              \labelwidth\leftmarginv
%              \advance\labelwidth-\labelsep}
%\def\@listvi {\leftmargin\leftmarginvi
%              \labelwidth\leftmarginvi
%              \advance\labelwidth-\labelsep}
%%%\endinput
%%
%% End of file `jsize10.clo'.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\setlength\columnsep{24\h}
\setlength\columnseprule{0\p@}
\setlength\lineskip{1\p@}
\setlength\normallineskip{1\p@}
\renewcommand{\baselinestretch}{}
\setlength\parskip{0\p@}
\setlength\parindent{1\Cwd}
\@lowpenalty   51
\@medpenalty  151
\@highpenalty 301

\setcounter{topnumber}{4}
\setcounter{bottomnumber}{4}
\setcounter{totalnumber}{6}
\setcounter{dbltopnumber}{5}
\renewcommand{\topfraction}{1}
\renewcommand{\bottomfraction}{1}
\renewcommand{\textfraction}{0}
\renewcommand{\floatpagefraction}{.5}
\renewcommand{\dbltopfraction}{1}
\renewcommand{\dblfloatpagefraction}{1}

\def\ps@plain{\let\@mkboth\@gobbletwo
   \let\ps@jpl@in\ps@plain
   \let\@oddhead\@empty
   \def\@oddfoot{\reset@font\hfil\thepage\hfil}%
   \let\@evenhead\@empty
   \let\@evenfoot\@oddfoot}
\let\ps@jpl@in\ps@plain

\def\ps@headnombre{\let\@mkboth\@gobbletwo
    \let\ps@jpl@in\ps@headnombre
  \def\@evenhead{\thepage\hfil}%
  \def\@oddhead{\hfil\thepage}%
  \let\@oddfoot\@empty\let\@evenfoot\@empty}

\def\ps@footnombre{\let\@mkboth\@gobbletwo
    \let\ps@jpl@in\ps@footnombre
  \def\@evenfoot{\thepage\hfil}%
  \def\@oddfoot{\hfil\thepage}%
  \let\@oddhead\@empty\let\@evenhead\@empty}


%%% from ieice.cls(uls)
%\newif\ifProof
%	\Prooftrue
%	\Prooffalse
\if@Proof
 \def\@Rtop{\rlap{\smash{\rule[-\headsep]{0.05mm}{10mm}%
  \rule[-\headsep]{10mm}{0.05mm}}}}
 \def\@Ltop{\llap{\smash{\rule[-\headsep]{10mm}{0.05mm}%
  \rule[-\headsep]{0.05mm}{10mm}}}}
 \def\@Rbot{\rlap{\smash{\raisebox{1\footskip}
  {\rule[-10mm]{0.05mm}{10mm}\rule{10mm}{0.05mm}}}}}
 \def\@Lbot{\llap{\smash{\raisebox{1\footskip}
  {\rule{10mm}{0.05mm}\rule[-10mm]{0.05mm}{10mm}}}}}
 \def\pot@jobname{\smash{\raise7mm\rlap{\LARGE\texttt{\jobname}}}}
\else
 \let\@Rtop\relax\let\@Ltop\relax\let\@Rbot\relax\let\@Lbot\relax
 \let\pot@jobname\relax
\fi


\def\ps@headings{%
\def\@oddfoot{\@Lbot\hspace*{1zw}{\EFhead 
Vol.\,\@VOL\hskip1zw No.\,\@NO\hskip2mm(\@YEAR)}
 \hfill{\EFnomble\thepage}\hskip1zw\mbox{}\@Rbot}
\def\@evenfoot{\@Lbot\hspace*{1zw}{\EFnomble\thepage}
 \hfill{\KFhead {ocHw_}\hskip1zw\mbox{}\@Rbot}
\def\@evenhead{\@Ltop\hfill\smash{\raisebox{25mm}{\@sadoku}}\@Rtop}
\def\@oddhead{\@Ltop\hfill\smash{\raisebox{25mm}{\@sadoku}}\@Rtop}
\def\sectionmark##1{\markboth {\uppercase{\ifnum \c@secnumdepth>\z@
 \thesection\hskip 1em\relax \fi ##1}}{}}
\def\subsectionmark##1{\markright{\ifnum \c@secnumdepth >\@ne
 \thesubsection\hskip 1em\relax \fi ##1}}}

%\def\ps@headings{\let\ps@jpl@in\ps@headnombre
%    \let\@oddfoot\@empty\let\@evenfoot\@empty
%    \def\@evenhead{\thepage\hfil\leftmark}%
%    \def\@oddhead{{\rightmark}\hfil\thepage}%
%    \let\@mkboth\markboth
%    \def\sectionmark##1{\markboth{%
%       \ifnum \c@secnumdepth >\z@ \thesection.\hskip1zw\fi
%       ##1}{}}%
%    \def\subsectionmark##1{\markright{%
%       \ifnum \c@secnumdepth >\@ne \thesubsection.\hskip1zw\fi
%       ##1}}%
%  }

\def\ps@myheadings{\let\ps@jpl@in\ps@plain%
  \let\@oddfoot\@empty\let\@evenfoot\@empty
  \def\@evenhead{\thepage\hfil\leftmark}%
  \def\@oddhead{{\rightmark}\hfil\thepage}%
  \let\@mkboth\@gobbletwo
  \let\sectionmark\@gobble
  \let\subsectionmark\@gobble
}


\def\ps@etitlehead{\let\@mkboth\@gobbletwo
\def\@oddfoot{\@Lbot\hspace*{1zw}{\EFhead 
 Vol.\,\@VOL\hskip1zw No.\,\@NO\hskip2mm(\@YEAR)}
 \hfill{\EFnomble\thepage}\hskip1zw\mbox{}\@Rbot}
\def\@evenfoot{\@Lbot\hspace*{1zw}{\EFnomble\thepage}
 \hfill{\KFhead {ocHw_}\hskip1zw\mbox{}\@Rbot}
\def\@oddhead{\@Ltop\hfill{\EFrmhead \mbox{}\hskip.5zw \mbox{}\hskip.5zw \mbox{}\hskip.5zw \mbox{}\hskip.5zw \mbox{}}\hskip1zw\mbox{}\smash{\raisebox{25mm}{\@sadoku}}\@Rtop}
\def\@evenhead{\@Ltop\hfill\smash{\raisebox{25mm}{\@sadoku}}}%\hfill{\EFrmhead J\hskip.5zw Jpn\hskip.5zw Ind\hskip.5zw Manage\hskip.5zw Assoc}\hskip1zw\mbox{}\@Rtop}
}

\def\ps@empty{\let\@mkboth\@gobbletwo\def\@oddhead{}\def\@oddfoot{}%
\def\@evenhead{}\def\@evenfoot{}}


\if@twoside
  \def\ps@bothstyle{\let\ps@jpl@in\ps@footnombre
    \def\@evenhead{\leftmark\hfil}% right page
    \def\@evenfoot{\thepage\hfil}% right page
    \def\@oddhead{\hfil\rightmark}% left page
    \def\@oddfoot{\hfil\thepage}% left page
  \let\@mkboth\markboth
  \def\sectionmark##1{\markboth{%
     \ifnum \c@secnumdepth >\z@ \thesection.\hskip1zw\fi
     ##1}{}}%
  \def\subsectionmark##1{\markright{%
     \ifnum \c@secnumdepth >\@ne \thesubsection.\hskip1zw\fi
     ##1}}%
  }
\else % if one column
  \def\ps@bothstyle{\let\ps@jpl@in\ps@footnombre
    \def\@oddhead{\hfil\rightmark}%
    \def\@oddfoot{\hfil\thepage}%
    \let\@mkboth\markboth
  \def\sectionmark##1{\markright{%
     \ifnum \c@secnumdepth >\m@ne \thesection.\hskip1zw\fi
     ##1}}%
  }
\fi

%%% \etitle ֘A̒`
\def\etitle#1{\gdef\@etitle{#1}}
\def\eauthor#1{\gdef\@eauthor{#1}}
\def\edate#1{\gdef\@edate{#1}}
\def\eabstract#1{\gdef\@eabstract{#1}}
\def\ekeyword#1{\gdef\@ekeyword{#1}}
\def\ethanks#1{\footnotemark\begingroup
\def\protect{\noexpand\protect\noexpand}\xdef\@ethanks{\@ethanks
  \protect\footnotetext[\the\c@footnote]{\protect\large#1}}\endgroup}
\def\@ethanks{}
%\@ethanks
% \renewcommand\thefootnote{\Arabic{footnote}}
% \setcounter{footnote}{0}


\def\keyword#1{\gdef\@keyword{#1}}
%\def\and{\hskip3mm}
%\def\AND{\hskip3mm and\hskip2mm}
%\def\footnum#1{\raise.3mm\hbox to 0pt{$^{\mbox{\small #1}}$\hss}}
\def\and{\hskip3mm,\hskip2mm}
\def\AND{\hskip4mm and\hskip2mm}
%\def\andJ{\hskip3mm,\hskip2mm}
\def\footnum#1{\raise.3mm\hbox to 0pt{$^{\mbox{\small $\dagger$#1}}$\hss}}
\def\footnumJ#1{\raise.3mm\hbox to 0pt{$^{\mbox{\scriptsize $\dagger$#1}}$\hss}}
\def\Arabic#1{\@Arabic{\@nameuse{c@#1}}}
\def\@Arabic#1{\ifcase#1\or 1\or 2\or 3\or 
   4\or 5\or 6\or 7\or 8 \or 9 \else\@ctrerr\fi\relax}

\long\def\@footnotetext#1{\insert\footins{\footnotesize
    \interlinepenalty\interfootnotelinepenalty 
    \splittopskip\footnotesep
    \splitmaxdepth \dp\strutbox \floatingpenalty \@MM
    \hsize\columnwidth \@parboxrestore
   \edef\@currentlabel{\csname p@footnote\endcsname\@thefnmark}\@makefntext
    {\rule{\z@}{\footnotesep}\ignorespaces
      \hangafter=1\hangindent=2zw#1\strut}}}

\def\@fnsymbol#1{\ifcase#1\or *\or **\or ***\or 
   ****\or *****\or \|\or **\or \dagger\dagger
   \or \ddagger\ddagger \else\@ctrerr\fi\relax}

%\def\thanks#1{{\LARGE\footnotemark
%\begingroup
%\def\protect{\noexpand\protect\noexpand}\xdef\@thanks{\@thanks
%  \protect\footnotetext[\the\c@footnote]{#1}}\endgroup}}
%\def\@thanks{}

%%%}N 
% oO  \cite,equation,\taublar͎gȂ
% s \hfill\break g
%\long\def\@Makefntext#1{\<i\makebox[1zw][c]{\@thefnmark}j\hskip.5zw#1}
\long\def\@Makefntext#1{{\bf }\makebox[1zw][c]{\bf\@thefnmark}\hskip1zw#1}
\def\notice#1{%
%%%
\def\@makefnmark{{\bf i\@thefnmarkj}}
%%%
\long\gdef\@footnotetext##1{%\insert\footins{\footnotesize
    \interlinepenalty\interfootnotelinepenalty 
    \splittopskip\footnotesep
    \splitmaxdepth \dp\strutbox \floatingpenalty \@MM
    \hsize\columnwidth \@parboxrestore
   \edef\@currentlabel{\csname p@footnote\endcsname\@thefnmark}\@Makefntext
    {\rule{\z@}{\footnotesep}\ignorespaces
      \hangafter=1\hangindent=3zw##1\strut\par}}%}
%%%
\footnotemark\begingroup
\def\protect{\noexpand\protect\noexpand}\xdef\@notice{\@notice
  \protect\footnotetext[\the\c@footnote]{\protect#1}}\endgroup}
\def\@notice{}

\newif\ifEtitle\Etitletrue


\def\maketitle{\par
 \begingroup
% \def\thefootnote{\fnsymbol{footnote}}
% \def\thefootnote{\Arabic{footnote}}
 \def\thefootnote{\dagger \Arabic{footnote}\ }
 \def\@makefnmark{\hbox 
 to 0pt{$^{\@thefnmark}$\hss}} 
 \if@twocolumn


%%% p^Cg
\ifEtitle
\def\footnoterule{\kern-3\p@ 
 \hrule width \columnwidth 
 %%%\hrule width 70mm%\columnwidth 
 \kern 2.6\p@} 
 \onecolumn
\null
\vskip-12mm
%{\Large Original}@{\Large\it Original}@{\Large\sl Original}\par
%{\Large\sl Original}\par
%{\Originalsl Original \hfill{\smash{\raisebox{7mm}{\protect\normalsize{J\hskip.5zw Jpn\hskip.5zw Ind\hskip.5zw Manage\hskip.5zw Assoc \hskip.5zw \mbox{\bf 48},\hskip.5zw 99--115, 1997}}}}}\par
{\Originalsl Original Paper \hfill{\smash{\raisebox{7mm}%
%{\protect\normalsize{\@headsitei}}}}}\par
{\protect\normalsize{J Jpn Ind Manage Assoc {\bf \@VOL}, \thepage--\pageref{LastPage}, \@YEAR}}}}}\par


%\vspace*{1mm}%^CgVt
\vskip1.5\baselineskip%%%!!!@
 \begin{Center}
%  {\huge\bf \@etitle \par} \vskip6.5mm  %32Q 8mmAL
   {\huge \@etitle \par} \vskip6.5mm  %32Q 8mmAL
{\LARGE%\lineskip .5em
\def\thefootnote{\dagger \Arabic{footnote}}
	%\begin{tabular}[t]{c}\@eauthor   \end{tabular}\par} 
	%\begin{tabular}[t]{c}
\@eauthor\par   
	%\end{tabular}\par
} 
 \end{Center}
  \par
  \vskip5mm %32Q 8mmAL
\centerline{{\Abstrm Abstract}}
  \vskip4.5mm %24Q 6mmAL
\centerline{{\parbox[t]{132mm}{\baselineskip=20\h\hspace*{2zw}\Abstrm\@eabstract}}}
%%%\centerline{\large\parbox[t]{132mm}{{\hspace*{2zw}\@eabstract}}}
\par\vskip7mm %32Q 8mmAL
%\centerline
%\centerline{\large Key words}\par\vskip3mm
%{\large Key words: }{\large\@ekeyword}
%\centerline{\large\@ekeyword}
\hspace*{6mm}{\large\parbox[t]{120mm}{\noindent{Key words:\hskip.5zw\@ekeyword}}}
\par
\thispagestyle{etitlehead}
%\@ethanks
\@ethanks
 \renewcommand\thefootnote{\Arabic{footnote}}
 \setcounter{footnote}{0}
\@ereceived%to
\@eaccepted%󗝏o
 \setcounter{footnote}{0}
\else\fi
%%% a^Cg
 \twocolumn[\@maketitle] 
 \else \newpage
 \global\@topnum\z@ \@maketitle \fi
\thispagestyle{headings}
\def\thefootnote{\dagger \Arabic{footnote}\ }
\@thanks
 \renewcommand\thefootnote{\Arabic{footnote}}
 \setcounter{footnote}{0}
\@received%to
\@accepted%󗝏o
 \endgroup
 \setcounter{footnote}{0}
 \let\maketitle\relax
 \let\@maketitle\relax
  \gdef\@thanks{}\gdef\@author{}\gdef\@title{}\gdef\@subtitle{}\let\thanks\relax}
%%% a^Cg̓e
\def\@maketitle{\newpage
\vskip-7mm
\parbox[t]{25mm}{{\KFronbun \rule{25mm}{.25mm}\par\hskip2.3mm \hskip0.5zw \hskip0.5zw _\hskip0.5zw \\[-2.5mm]%
\rule{25mm}{.25mm}}}\par
%%%\hbox to 23mm{\hss{\large\bf _\hskip3zw }\hss}\par
\vspace*{2mm}%^CgVt
%%%\vspace*{1mm}%^CgVt
\begin{Center}
 {\Huge \@title \par}
\vskip 5mm%28Q 7mm AL
\def\thefootnote{\hskip0.1zw\dagger \Arabic{footnote}}
 {\KFauthor\@author\par}
\end{Center}
 \par
\vskip3.5mm %24Q 6mm AL
\hfil\parbox[t]{132.5mm}{%10Q 14h 53l
\footnotesize\@abstract}
\par\vspace{\baselineskip}
\hfil{\normalsize\parbox[t]{132.5mm}{\noindent{L[[hF\hskip.5zw\@keyword}}}
\par\vskip2\baselineskip
} 
%%% aAuXg
\def\abstract#1{\gdef\@abstract{\hskip1zw#1}}
%
\mark{{}{}} 

%%% t}N
\def\ereceived#1#2#3{\begingroup
\def\protect{\noexpand\protect\noexpand}\xdef\@ereceived{\@ereceived
  \protect\footnotetext[0]{\protect\large Received\hskip.5mm: #1\hskip2mm #2,\hskip2mm #3}}\endgroup}
\def\@ereceived{}

%%% 󗝃}N
\def\eaccepted#1#2#3{\begingroup
\def\protect{\noexpand\protect\noexpand}\xdef\@eaccepted{\@eaccepted
  \protect\footnotetext[0]{\protect\large Accepted: #1\hskip2mm #2,\hskip2mm #3}}\endgroup}
\def\@eaccepted{}

%%% t}N
\def\received#1{\begingroup
\def\protect{\noexpand\protect\noexpand}\xdef\@received{\@received
  \protect\footnotetext[0]{tF#1}}\endgroup}
\def\@received{}

%%% 󗝃}N
\def\accepted#1{\begingroup
\def\protect{\noexpand\protect\noexpand}\xdef\@accepted{\@accepted
  \protect\footnotetext[0]{󗝁F#1}}\endgroup}
\def\@accepted{}

%%% headings ֘A̒`
\def\VOL#1{\gdef\@VOL{#1}}
\def\NO#1{\gdef\@NO{#1}}
\def\YEAR#1{\gdef\@YEAR{#1}}

\def\headsitei#1{\def\@headsitei{#1}}
\def\@headsitei{}
\def\sadoku{\gdef\@sadoku{}}
\def\@sadoku{}



\setcounter{secnumdepth}{3}

\newcounter{part}
\newcounter{section}
\newcounter{subsection}[section]
\newcounter{subsubsection}[subsection]
\newcounter{paragraph}[subsubsection]
\newcounter{subparagraph}[paragraph]

\renewcommand{\thepart}{\@Roman\c@part}
\renewcommand{\thesection}{\@arabic\c@section}
\renewcommand{\thesubsection}{\thesection.\@arabic\c@subsection}
\renewcommand{\thesubsubsection}{%
   \thesubsection.\@arabic\c@subsubsection}
\renewcommand{\theparagraph}{%
   \thesubsubsection.\@arabic\c@paragraph}
\renewcommand{\thesubparagraph}{%
   \theparagraph.\@arabic\c@subparagraph}

\newcommand{\part}{\par\addvspace{4ex}%
  \@afterindentfalse
  \secdef\@part\@spart}
\def\@part[#1]#2{%
  \ifnum \c@secnumdepth >\m@ne
    \refstepcounter{part}%
    \addcontentsline{toc}{part}{%
       \prepartname\thepart\postpartname\hspace{1zw}#1}%
  \else
    \addcontentsline{toc}{part}{#1}%
  \fi
  \markboth{}{}%
  {\parindent\z@\raggedright
   \interlinepenalty\@M\reset@font
   \ifnum \c@secnumdepth >\m@ne
     \Large\bfseries\prepartname\thepart\postpartname
     \par\nobreak
   \fi
   \huge\bfseries#2\par}%
  \nobreak\vskip3ex\@afterheading}
\def\@spart#1{{%
  \parindent\z@\raggedright
  \interlinepenalty\@M\reset@font
  \huge\bfseries#1\par}%
  \nobreak\vskip3ex\@afterheading}


\def\@startsection#1#2#3#4#5#6{\if@noskipsec \leavevmode \fi
   \par \@tempskipa #4\relax
   \@afterindenttrue
   \ifdim \@tempskipa <\z@ \@tempskipa -\@tempskipa \@afterindentfalse\fi
   \if@nobreak \everypar{}\else
     \addpenalty{\@secpenalty}
%% sectionœł2sZ^[ɂ
	\ifnum#2=\@ne
	    \vskip-\prevdepth \prevdepth\z@ \vskip\baselineskip
	\advance\@tempskipa-\baselineskip \vspace*{\@tempskipa}%%̍ssectionœVtɂȂ
	\else\addvspace{\@tempskipa}\fi\fi 
%%
\@ifstar
     {\@ssect{#3}{#4}{#5}{#6}}{\@dblarg{\@sect{#1}{#2}{#3}{#4}{#5}{#6}}}}


\newbox\Secbox
\newbox\Subsecbox

%%% sectioniԍtj̓}N
% \@sect{NAME}{LEVEL}{INDENT}{BEFORESKIP}{AFTERSKIP}{STYLE}[ARG1]{ARG2} ==
\def\@sect#1#2#3#4#5#6[#7]#8{\ifnum #2>\c@secnumdepth
     \def\@svsec{}\else 
     \refstepcounter{#1}\edef\@svsec{\csname the#1\endcsname\hskip1zw}\fi
     \@tempskipa #5\relax
      \ifdim \@tempskipa>\z@ 
        \begingroup #6\relax
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% section,subsection,subsubsection ̎
    \ifnum #2=\@ne %1 section
      \setbox\Secbox\hbox{#8}%
      \ifdim \wd\Secbox > 7zw
          \@hangfrom{\hskip #3\relax\@svsec}{\interlinepenalty \@M #8\par}%
      \else
          \@hangfrom{\hskip #3\relax\@svsec}{\interlinepenalty \@M \kintou{7zw}{#8}\par}%
      \fi
    \else%1
     \ifnum #2 > \@ne %2 subsection,subsebsection
        \setbox\Subsecbox\hbox{#8}%
        \ifdim \wd\Subsecbox > 5zw
           \@hangfrom{\hskip #3\relax\@svsec}{\interlinepenalty \@M #8\par}%
        \else
           \@hangfrom{\hskip #3\relax\@svsec}{\interlinepenalty \@M \kintou{5zw}{#8}\par}%
        \fi
     \else%2
     \fi%2
    \fi%1
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        \endgroup
       \csname #1mark\endcsname{#7}\addcontentsline
         {toc}{#1}{\ifnum #2>\c@secnumdepth \else
                      \protect\numberline{\csname the#1\endcsname}\fi
                    #7}\else
        \def\@svsechd{#6\hskip #3\@svsec #8\csname #1mark\endcsname
                      {#7}\addcontentsline
                           {toc}{#1}{\ifnum #2>\c@secnumdepth \else
                             \protect\numberline{\csname the#1\endcsname}\fi
                       #7}}\fi
     \@xsect{#5}}

%%% section*iԍj̓}N
\def\@ssect#1#2#3#4#5{\@tempskipa #3\relax
   \ifdim \@tempskipa>\z@
     \begingroup #4\@hangfrom{\hskip #1}{\interlinepenalty \@M #5\par}\endgroup
   \else \def\@svsechd{#4\hskip #1\relax #5}\fi
    \@xsect{#3}}


%%% Tu^Cg ----> \title{xxxxxxx\\{\Large xxxxxx}} Ƃi16Qj  


\newcommand{\section}{\@startsection{section}{1}{\z@}%
   {.5\baselineskip plus .5mm minus .5mm}%
   {.5\baselineskip plus .5mm minus .5mm}%
   {\reset@font\bfseries}}
\newcommand{\subsection}{\@startsection{subsection}{2}{\z@}%
   {1\baselineskip plus .5mm minus .5mm}%
   {0.001\baselineskip plus .1mm minus .1mm}%
   {\reset@font\bfseries}}
\newcommand{\subsubsection}{\@startsection{subsubsection}{3}{\z@}%
   {0.001\baselineskip}% plus .1mm minus .1mm}%
   {0.001\baselineskip}% plus .1mm minus .1mm}%
   {\reset@font\bfseries}}
\newcommand{\paragraph}{\@startsection{paragraph}{4}{\z@}%
   {3.25ex \@plus 1ex \@minus .2ex}%
   {-1em}%
   {\reset@font\normalsize\bfseries}}
\newcommand{\subparagraph}{\@startsection{subparagraph}{4}{\parindent}%
   {3.25ex \@plus 1ex \@minus .2ex}%
   {-1em}%
   {\reset@font\normalsize\bfseries}}

%%% t^
\def\appendix{\nopagebreak[4]
\vskip\baselineskip
\noindent{\bf t@@@@@^}\@ifstar{\STARappendix}{\NSTARappendix}}
\def\STARappendix{\par% appendix* iԍj
 \setcounter{section}{0}
 \setcounter{subsection}{0}
 \def\thesection{t^}}
\def\NSTARappendix{\par% appendix iԍtj
 \setcounter{section}{0}
 \setcounter{subsection}{0}
 \def\thesection{\arabic{section}}}

%\newcommand{\appendix}{\par
%  \setcounter{section}{0}%
%  \setcounter{subsection}{0}%
%  \renewcommand{\thesection}{\@Alph\c@section}}


\leftmargini 25pt
\leftmarginii 22pt 
\leftmarginiii 18.7pt 
\leftmarginiv 17pt 
\leftmarginv 10pt
\leftmarginvi 10pt
\leftmargin\leftmargini
\labelwidth\leftmargini\advance\labelwidth-\labelsep
\labelsep 5pt

%\if@twocolumn
%  \setlength\leftmargini {2em}
%\else
%  \setlength\leftmargini {2.5em}
%\fi
%\setlength\leftmarginii  {2.2em}
%\setlength\leftmarginiii {1.87em}
%\setlength\leftmarginiv  {1.7em}
%\if@twocolumn
%  \setlength\leftmarginv {.5em}
%  \setlength\leftmarginvi{.5em}
%\else
%  \setlength\leftmarginv {1em}
%  \setlength\leftmarginvi{1em}
%\fi
%\setlength  \labelsep  {.5em}
%\setlength  \labelwidth{\leftmargini}
%\addtolength\labelwidth{-\labelsep}

\@beginparpenalty -\@lowpenalty
\@endparpenalty   -\@lowpenalty
\@itempenalty     -\@lowpenalty

\renewcommand{\theenumi}{\@arabic\c@enumi}
\renewcommand{\theenumii}{\@alph\c@enumii}
\renewcommand{\theenumiii}{\@roman\c@enumiii}
\renewcommand{\theenumiv}{\@Alph\c@enumiv}
%
\newcommand{\labelenumi}{\theenumi}
\newcommand{\labelenumii}{(\theenumii)}
\newcommand{\labelenumiii}{\theenumiii.}
\newcommand{\labelenumiv}{\theenumiv.}
%
\renewcommand{\p@enumii}{\theenumi}
\renewcommand{\p@enumiii}{\theenumi(\theenumii)}
\renewcommand{\p@enumiv}{\p@enumiii\theenumiii}


\def\enumerate{%
\def\labelenumi{i\makebox[1zw][c]{\theenumi}j} 
\ifnum \@enumdepth >3 \@toodeep\else
      \advance\@enumdepth \@ne 
      \edef\@enumctr{enum\romannumeral\the\@enumdepth}\list
      {\csname label\@enumctr\endcsname}{\usecounter
        {\@enumctr}\def\makelabel##1{\hss\llap{##1}}
        %\itemindent=-.5zw
        \labelsep=1zw
%------- '96 12/10 ǉ -----------------------
        \listparindent=1zw%
%----------------------------------------------
        \partopsep=0pt\itemsep=0pt\topsep=0pt\parsep=0pt}\fi}
\let\endenumerate =\endlist

%\renewenvironment{enumerate}
%  {\ifnum \@enumdepth >3\relax\@toodeep\else
%   \advance\@enumdepth\@ne
%   \edef\@enumctr{enum\romannumeral\the\@enumdepth}%
%   \list{\csname label\@enumctr\endcsname}{%
%         \ifnum \@listdepth=\@ne \topsep.5\normalbaselineskip
%           \else\topsep\z@\fi
%         \parskip\z@ \itemsep\z@ \parsep\z@
%         \labelwidth1zw \labelsep.3zw
%         \ifnum \@enumdepth=\@ne \leftmargin1zw\relax
%           \else\leftmargin\leftskip\fi
%         \advance\leftmargin 1zw
%         \usecounter{\@enumctr}%
%         \def\makelabel##1{\hss\llap{##1}}}%
%   \fi}{\endlist}


\def\freeenumerate#1{%
\def\labelenumi{#1} 
\ifnum \@enumdepth >3 \@toodeep\else
      \advance\@enumdepth \@ne 
      \edef\@enumctr{enum\romannumeral\the\@enumdepth}\list
      {\csname label\@enumctr\endcsname}{\usecounter
        {\@enumctr}\def\makelabel##1{\hss\llap{##1}}
        %\itemindent=-.5zw
        \labelsep=1zw
%------- '96 12/18 ǉ -----------------------
        \listparindent=1zw%
%----------------------------------------------
        \partopsep=0pt\itemsep=0pt\topsep=0pt\parsep=0pt}\fi}
\let\endfreeenumerate =\endlist
%use \begin{freeenumerate}{\theenumij} .... \end{freeenumerate}  1j,2j....


\newcommand{\labelitemi}{$\bullet$}
\newcommand{\labelitemii}{%
E%
%  \iftdir
%     {\textcircled{~}}
%  \else
%     {\normalfont\bfseries\textendash}
%  \fi
}
\newcommand{\labelitemiii}{$\ast$}
\newcommand{\labelitemiv}{$\cdot$}


\def\itemize{\ifnum \@itemdepth >3 \@toodeep\else \advance\@itemdepth \@ne
  \edef\@itemitem{labelitem\romannumeral\the\@itemdepth}%
  \list{\csname\@itemitem\endcsname}{\def\makelabel##1{\hss\llap{##1}}
  %\itemindent=.5zw
  \leftmargin\itemindent
  \advance\leftmargin by 1.2zw
  \partopsep=0pt\itemsep=0pt\topsep=0pt\parsep=0pt}\fi}
\let\enditemize =\endlist

%\renewenvironment{itemize}
%  {\ifnum \@itemdepth >3\relax\@toodeep\else
%   \advance\@itemdepth\@ne
%   \edef\@itemitem{labelitem\romannumeral\the\@itemdepth}%
%   \expandafter
%   \list{\csname \@itemitem\endcsname}{%
%      \iftdir
%         \ifnum \@listdepth=\@ne \topsep.5\normalbaselineskip
%           \else\topsep\z@\fi
%         \parskip\z@ \itemsep\z@ \parsep\z@
%         \labelwidth1zw \labelsep.3zw
%         \ifnum \@itemdepth =\@ne \leftmargin1zw\relax
%           \else\leftmargin\leftskip\fi
%         \advance\leftmargin 1zw
%      \fi
%         \def\makelabel##1{\hss\llap{##1}}}%
%   \fi}{\endlist}


\def\descriptionlabel#1{\hspace\labelsep \bfseries #1}
\def\description{\list{}{\labelwidth\z@ \itemindent-\leftmargin
 \let\makelabel\descriptionlabel
\partopsep=0pt\itemsep=0pt\topsep=0pt\parsep=0pt}}
\let\enddescription\endlist

%\newenvironment{description}
%  {\list{}{\labelwidth\z@ \itemindent-\leftmargin
%   \iftdir
%     \leftmargin\leftskip \advance\leftmargin3\Cwd
%     \rightmargin\rightskip
%     \labelsep=1zw \itemsep\z@
%     \listparindent\z@ \topskip\z@ \parskip\z@ \partopsep\z@
%   \fi
%           \let\makelabel\descriptionlabel}}{\endlist}
%\newcommand{\descriptionlabel}[1]{%
%   \hspace\labelsep\normalfont\bfseries #1}


\def\freedescriptionlabel#1{\hspace\labelsep \bf #1}
\def\freedescription#1{\list{}{\labelwidth\z@ 
\leftmargin=#1
\itemindent-\leftmargin
 \let\makelabel\freedescriptionlabel
\partopsep=0pt\itemsep=0pt\topsep=0pt\parsep=0pt}}
\let\endfreedescription\endlist
%use \begin{freedescription}{2zw} .... \end{freedescription} Cfg


\newenvironment{verse}
  {\let\\\@centercr
   \list{}{\itemsep\z@ \itemindent -1.5em%
           \listparindent\itemindent
           \rightmargin\leftmargin \advance\leftmargin 1.5em}%
           \item\relax}{\endlist}

\newenvironment{quotation}
  {\list{}{\listparindent 1.5em%
           \itemindent\listparindent
           \rightmargin\leftmargin
           \parsep\z@ \@plus\p@}%
           \item\relax}{\endlist}

\newenvironment{quote}
  {\list{}{\rightmargin\leftmargin}%
           \item\relax}{\endlist}


%%% ʍsĐ     \mathindent by SATOH[
\def\[{\relax\ifmmode\@badmath\else
 \parsep 3pt plus 1pt minus 1pt \topsep 5pt plus 2pt minus 2pt 
 \itemsep 3pt plus 1pt minus 1pt
\begin{trivlist}\item[]\leavevmode
 \hbox to\linewidth\bgroup$ \displaystyle
 \hskip\mathindent\bgroup\fi}
\def\]{\relax\ifmmode \egroup $\hfil \egroup \end{trivlist}\else \@badmath \fi}

\def\equation{\refstepcounter{equation}
 \parsep 3pt plus 1pt minus 1pt \topsep 5pt plus 2pt minus 2pt 
 \itemsep 3pt plus 1pt minus 1pt
\trivlist \item[]\leavevmode
 \hbox to\linewidth\bgroup $ \displaystyle
\hskip\mathindent}
\def\endequation{$\hfil \displaywidth\linewidth\@eqnnum\egroup \endtrivlist}

\def\eqnarray{\stepcounter{equation}
 \parsep 3pt plus 1pt minus 1pt \topsep 5pt plus 2pt minus 2pt 
 \itemsep 3pt plus 1pt minus 1pt
\let\@currentlabel=\theequation
\global\@eqnswtrue
\global\@eqcnt\z@\tabskip\mathindent\let\\=\@eqncr
\abovedisplayskip\topsep\ifvmode\advance\abovedisplayskip\partopsep\fi
\belowdisplayskip\abovedisplayskip
\belowdisplayshortskip\abovedisplayskip
\abovedisplayshortskip\abovedisplayskip
$$\halign to
\linewidth\bgroup\@eqnsel\hskip\@centering$\displaystyle\tabskip\z@
 {##}$&\global\@eqcnt\@ne \hskip .8\arraycolsep \hfil${##}$\hfil%% 2\arraycolsep
 &\global\@eqcnt\tw@ \hskip .8\arraycolsep $\displaystyle{##}$\hfil 
 \tabskip\@centering&\llap{##}\tabskip\z@\cr}
\def\endeqnarray{\@@eqncr\egroup
 \global\advance\c@equation\m@ne$$\global\@ignoretrue }
\newdimen\mathindent 
\mathindent = 6mm

%%% ԍo   
\def\@eqnnum{{\rm (\theequation)\hskip1zw}}

\def\theequation{\arabic{equation}}
%%%%\renewcommand{\theequation}{\@arabic\c@equation}


%%% float̃TCYw
\def\@floatboxreset{%
  \reset@font
  \Footnotesize\tabcolsep.5zw
}

%%% center̑ÕAL by SATOH[
\def\Center{\itemsep\z@\topsep\z@\parsep\z@\trivlist\Centering\item[]}
\def\Centering{\let\\=\@centercr\rightskip\@flushglue\leftskip\@flushglue
\parindent\z@\parfillskip\z@}
\let\endCenter=\endtrivlist

\newdimen\@abovecapskip
\newdimen\@belowcapskip

\newbox\capnumberbox
\newbox\capbox

\long\def\@makecaption#1#2{{\small%
 \vskip\@abovecapskip
 %
 \setbox\capnumberbox\hbox{{\bf #1}\hskip1zw}
 \setbox\capbox\hbox{{\bf #1}\hskip1zw #2}
 %
 \ifdim\wd\capbox < \hsize
  \hbox to\hsize{\hfil\box\capbox\hfil}
  \vspace{\@belowcapskip}
 \else
  \hfil\begin{minipage}[t]{\hsize}%
  \hangindent=\wd\capnumberbox\hangafter=1%
  {\bf #1}\hskip1zw{}#2%
  \end{minipage}
  \vspace{\@belowcapskip}
 \fi}}

%%% by STYLE USE
\newsavebox{\@parc@ption}
\def\parcaption#1{\small%
    \sbox{\@parc@ption}{\shortstack[l]{#1}}%
    \setbox\@tempboxa\hbox{\csname fnum@\@captype\endcsname\hskip1zw}%\hskip1zwǉ
    \@tempdima\hsize \advance\@tempdima-\wd\@tempboxa%
    \@tempdimb .97\@tempdima%<-- maximum length is set here
    \ifdim\wd\@parc@ption>\@tempdimb \@tempdima\@tempdimb%
     \else\@tempdima\wd\@parc@ption\fi%
    \sbox{\@tempboxa}{\parbox[t]{\@tempdima}{#1}}%
    \caption{\usebox{\@tempboxa}}\Footnotesize}

\newcounter{figure}
\def\thefigure{\@arabic\c@figure}
\def\fps@figure{tbp}
\def\ftype@figure{1}
\def\ext@figure{lof}
\def\fnum@figure{}\,\thefigure}
%\def\figure{\bgroup\footnotesize\let\center\Center%
\def\figure{\bgroup\let\center\Center%
\@abovecapskip=1mm\@belowcapskip\z@\@float{figure}}
\def\endfigure{\end@float\egroup}
\@namedef{figure*}{\bgroup\footnotesize\let\center\Center%
\@abovecapskip=1mm\@belowcapskip\z@\@dblfloat{figure}}
\@namedef{endfigure*}{\end@dblfloat\egroup}

\newcounter{table}
\def\thetable{\@arabic\c@table}
\def\fps@table{tbp}
\def\ftype@table{2}
\def\ext@table{lot}
\def\fnum@table{\\,\thetable}
%\def\table{\bgroup\Footnotesize\let\center\Center%
\def\table{\bgroup\let\center\Center%
\@abovecapskip\z@\@belowcapskip=0.5mm\@float{table}}
\def\endtable{\end@float\egroup}
\@namedef{table*}{\bgroup\Footnotesize\let\center\Center%
\@abovecapskip\z@\@belowcapskip=0.5mm\@dblfloat{table}}
\@namedef{endtable*}{\end@dblfloat\egroup}


%% force "{figure*}" at the bottom by SATOH[
\newdimen\capwidth%%%!!!
\capwidth=\wd\capbox%%%!!!
\newbox\@dummyfigbox
\def\twocolcaption#1{\vskip\@abovecapskip
\def\test@captype{figure}
\ifx \@captype\test@captype
 \refstepcounter{figure}%
\else
 \refstepcounter{table}%
\fi
\setbox\@dummyfigbox\hbox{{\small\bf \csname fnum@\@captype\endcsname}%
 \hskip1zw{\small #1}}
\capwidth=\textwidth
\divide \capwidth by 3
\multiply \capwidth by 2
\ifdim \wd\@dummyfigbox < \capwidth%
\noindent\hbox to \columnwidth{\hbox to \textwidth{\hss\copy\@dummyfigbox\hss}\hss}\par
\else
\setbox\@dummyfigbox\hbox{%
\begin{minipage}[t]{\capwidth}%
{\small\bf \csname fnum@\@captype\endcsname}\hskip1zw{\small #1}%
\end{minipage}}%
\noindent\hbox to \columnwidth{\hbox to \textwidth{\hss\copy\@dummyfigbox\hss}\hss}\par
\fi}

\def\dummyfigure#1{%
\begin{figure}[b]
\vspace{#1}
\vskip\@abovecapskip
\phantom{\box\@dummyfigbox}\par
\end{figure}
}

%%% example figure
% \begin{figure}[b] % left column
% \vspace{10mm}
% \twocolcaption{}
% \end{figure}
% \dummyfigure{10mm} % right column
%%% example table
% \begin{table}[b] % left column
% \twocolcaption{}
% \vspace{2mm}
% \hbox to \textwidth{\hss
% \begin{tabular}{}
% \end{tabular}
% \hss}
% \end{table}
% \dummyfigure{tabular height, XXmm} % right column


%\newcounter{figure}
%\renewcommand{\thefigure}{\@arabic\c@figure}
%\def\fps@figure{tbp}
%\def\ftype@figure{1}
%\def\ext@figure{lof}
%\def\fnum@figure{\figurename~\thefigure}
%\newenvironment{figure}
%               {\@float{figure}}
%               {\end@float}
%\newenvironment{figure*}
%               {\@dblfloat{figure}}
%               {\end@dblfloat}
%
%\newcounter{table}
%\renewcommand{\thetable}{\@arabic\c@table}
%\def\fps@table{tbp}
%\def\ftype@table{2}
%\def\ext@table{lot}
%\def\fnum@table{\tablename~\thetable}
%\newenvironment{table}
%               {\@float{table}}
%               {\end@float}
%\newenvironment{table*}
%               {\@dblfloat{table}}
%               {\end@dblfloat}
%\newlength\abovecaptionskip
%\newlength\belowcaptionskip
%\setlength\abovecaptionskip{10\p@}
%\setlength\belowcaptionskip{0\p@}
%
%\long\def\@makecaption#1#2{%
%  \vskip\abovecaptionskip
%  \iftdir\sbox\@tempboxa{#1\hskip1zw#2}%
%    \else\sbox\@tempboxa{#1: #2}%
%  \fi
%  \ifdim \wd\@tempboxa >\hsize
%    \iftdir #1\hskip1zw#2\relax\par
%      \else #1: #2\relax\par\fi
%  \else
%    \global \@minipagefalse
%    \hbox to\hsize{\hfil\box\@tempboxa\hfil}%
%  \fi
%  \vskip\belowcaptionskip}


\setlength\arraycolsep{5\p@}
\setlength\tabcolsep{.5zw}
\setlength\arrayrulewidth{.4\p@}
\setlength\doublerulesep{1.4pt}%
\setlength\tabbingsep{\labelsep}

\skip\@mpfootins = \skip\footins
\setlength\fboxsep{3\p@}
\setlength\fboxrule{.4\p@}



\def\@cite#1#2{[{#1\if@tempswa,#2\fi}]}

%%% CITESORT.STY
\newcount\@minsofar
\newcount\@min
\newcount\@cite@temp
\def\@citex[#1]#2{%
\if@filesw \immediate \write \@auxout {\string \citation {#2}}\fi
\@tempcntb\m@ne \let\@h@ld\relax \def\@citea{}%
\@min\m@ne%
\@cite{%
  \@for \@citeb:=#2\do {\@ifundefined {b@\@citeb}%
    {\@h@ld\@citea\@tempcntb\m@ne{\bf ?}%
    \@warning {Citation `\@citeb ' on page \thepage \space undefined}}%
{\@minsofar\z@ \@for \@scan@cites:=#2\do {%
  \@ifundefined{b@\@scan@cites}%
    {\@cite@temp\m@ne}
    {\@cite@temp\number\csname b@\@scan@cites \endcsname \relax}%
\ifnum\@cite@temp > \@min% select the next one to list
    \ifnum\@minsofar = \z@
      \@minsofar\number\@cite@temp
      \edef\@scan@copy{\@scan@cites}\else
    \ifnum\@cite@temp < \@minsofar
      \@minsofar\number\@cite@temp
      \edef\@scan@copy{\@scan@cites}\fi\fi\fi}\@tempcnta\@min
  \ifnum\@minsofar > \z@ % some more
    \advance\@tempcnta\@ne
    \@min\@minsofar
    \ifnum\@tempcnta=\@minsofar %   Number follows previous--hold on to it
      \ifx\@h@ld\relax
        \edef \@h@ld{\@citea\csname b@\@scan@copy\endcsname}%
      \else \edef\@h@ld{\ifmmode{]-\allowbreak[}\else]\<`\allowbreak\<[\fi
         \csname b@\@scan@copy\endcsname}%
      \fi
    \else \@h@ld\@citea\csname b@\@scan@copy\endcsname
          \let\@h@ld\relax
  \fi % no more
\fi}%
\def\@citea{]\<,\<\penalty\@highpenalty[}}\@h@ld}{#1}}
%% end of citesort.sty



\if@enablejfam
  \DeclareSymbolFont{mincho}{JY1}{mc}{m}{n}
  \DeclareSymbolFontAlphabet{\mathmc}{mincho}
  \SetSymbolFont{mincho}{bold}{JY1}{gt}{m}{n}
  \DeclareMathAlphabet{\mathgt}{JY1}{gt}{m}{n}
  \reDeclareMathAlphabet{\mathrm}{\@mathrm}{\@mathmc}
  \reDeclareMathAlphabet{\mathbf}{\@mathbf}{\@mathgt}
  \jfam\symmincho
\else
  \DeclareRobustCommand{\mathmc}{%
    \@latex@error{Command \noexpand\mathmc invalid with\space
       `disablejfam' class option.}\@eha
  }
  \DeclareRobustCommand{\mathgt}{%
    \@latex@error{Command \noexpand\mathgt invalid with\space
       `disablejfam' class option.}\@eha
  }
\fi
\DeclareOldFontCommand{\mc}{\normalfont\mcfamily}{\mathmc}
\DeclareOldFontCommand{\gt}{\normalfont\gtfamily}{\mathgt}
\DeclareOldFontCommand{\rm}{\normalfont\rmfamily}{\mathrm}
\DeclareOldFontCommand{\sf}{\normalfont\sffamily}{\mathsf}
\DeclareOldFontCommand{\tt}{\normalfont\ttfamily}{\mathtt}
\DeclareOldFontCommand{\bf}{\normalfont\bfseries}{\mathbf}
\DeclareOldFontCommand{\it}{\normalfont\itshape}{\mathit}
\DeclareOldFontCommand{\sl}{\normalfont\slshape}{\@nomath\sl}
\DeclareOldFontCommand{\sc}{\normalfont\scshape}{\@nomath\sc}
\DeclareRobustCommand*{\cal}{\@fontswitch\relax\mathcal}
\DeclareRobustCommand*{\mit}{\@fontswitch\relax\mathnormal}

\setcounter{tocdepth}{3}

\newcommand{\@pnumwidth}{1.55em}
\newcommand{\@tocrmarg}{2.55em}
\newcommand{\@dotsep}{4.5}

\newdimen\toclineskip
\setlength\toclineskip{\z@}
\newdimen\@lnumwidth
\def\numberline#1{\hbox to\@lnumwidth{#1\hfil}}
\def\@dottedtocline#1#2#3#4#5{\ifnum #1>\c@tocdepth \else
  \vskip\toclineskip \@plus.2\p@
  {\leftskip #2\relax \rightskip \@tocrmarg \parfillskip -\rightskip
    \parindent #2\relax\@afterindenttrue
   \interlinepenalty\@M
   \leavevmode
   \@lnumwidth #3\relax
   \advance\leftskip \@lnumwidth \hbox{}\hskip -\leftskip
    {#4}\nobreak\leaders\hbox{$\m@th \mkern \@dotsep mu.\mkern \@dotsep
       mu$}\hfill \nobreak\hbox to\@pnumwidth{%
         \hss\reset@font\rmfamily \normalcolor #5}\par}\fi}
\def\addcontentsline#1#2#3{%
  \protected@write\@auxout
    {\let\label\@gobble \let\index\@gobble \let\glossary\@gobble
\@temptokena{\thepage}}%
    {\string\@writefile{#1}%
       {\protect\contentsline{#2}{#3}{\the\@temptokena}}}%
}

\newcommand{\tableofcontents}{%
  \section*{\contentsname
    \@mkboth{\contentsname}{\contentsname}%
  }\@starttoc{toc}%
}
\newcommand*{\l@part}[2]{%
  \ifnum \c@tocdepth >-2\relax
    \addpenalty{\@secpenalty}%
    \addvspace{2.25em \@plus\p@}%
    \begingroup
    \parindent\z@\rightskip\@pnumwidth
    \parfillskip-\@pnumwidth
    {\leavevmode\large\bfseries
     \setlength\@lnumwidth{4zw}%
     #1\hfil\nobreak
     \hbox to\@pnumwidth{\hss#2}}\par
    \nobreak
    \if@compatibility
    \global\@nobreaktrue
    \everypar{\global\@nobreakfalse\everypar{}}%
    \fi
     \endgroup
  \fi}
\newcommand*{\l@section}[2]{%
  \ifnum \c@tocdepth >\z@
    \addpenalty{\@secpenalty}%
    \addvspace{1.0em \@plus\p@}%
    \begingroup
      \parindent\z@ \rightskip\@pnumwidth \parfillskip-\rightskip
      \leavevmode\bfseries
      \setlength\@lnumwidth{1.5em}%
      \advance\leftskip\@lnumwidth \hskip-\leftskip
      #1\nobreak\hfil\nobreak\hbox to\@pnumwidth{\hss#2}\par
    \endgroup
  \fi}
\newcommand*{\l@subsection}   {\@dottedtocline{2}{1.5em}{2.3em}}
\newcommand*{\l@subsubsection}{\@dottedtocline{3}{3.8em}{3.2em}}
\newcommand*{\l@paragraph}    {\@dottedtocline{4}{7.0em}{4.1em}}
\newcommand*{\l@subparagraph} {\@dottedtocline{5}{10em}{5em}}
\newcommand{\listoffigures}{%
    \section*{\listfigurename
  \@mkboth{\listfigurename}{\listfigurename}}%
  \@starttoc{lof}%
}
\newcommand*{\l@figure}{\@dottedtocline{1}{1.5em}{2.3em}}
\newcommand{\listoftables}{%
    \section*{\listtablename
  \@mkboth{\listtablename}{\listtablename}}%
  \@starttoc{lot}%
}
\let\l@table\l@figure


\def\thebibliography#1{\section*{Q\hskip1zw l\hskip1zw \hskip1zw \markboth
 {Q l  }{Q l  }}\small
\list{[\makebox[1zw][c]{\arabic{enumi}}]}{\settowidth\labelwidth{[\makebox[1zw]{#1}]}%
\itemindent=-.5zw
%\leftmargin\labelwidth
\labelsep=1zw
% \advance\leftmargin\labelsep
\itemsep=0pt\topsep=0pt\parsep=0pt
 \usecounter{enumi}}
 \def\newblock{\hskip .11em plus .33em minus .07em}
 \sloppy
 \sfcode`\.=1000\relax}
\let\endthebibliography=\endlist


%\newdimen\bibindent
%\setlength\bibindent{1.5em}
%\newcommand{\newblock}{\hskip .11em\@plus.33em\@minus.07em}
%\newenvironment{thebibliography}[1]
%{\section*{\refname\@mkboth{\refname}{\refname}}%
%   \list{\@biblabel{\@arabic\c@enumiv}}%
%        {\settowidth\labelwidth{\@biblabel{#1}}%
%         \leftmargin\labelwidth
%         \advance\leftmargin\labelsep
%         \@openbib@code
%         \usecounter{enumiv}%
%         \let\p@enumiv\@empty
%         \renewcommand\theenumiv{\@arabic\c@enumiv}}%
%   \sloppy
%   \clubpenalty4000
%   \@clubpenalty\clubpenalty
%   \widowpenalty4000%
%   \sfcode`\.\@m}
%  {\def\@noitemerr
%    {\@latex@warning{Empty `thebibliography' environment}}%
%   \endlist}
%\let\@openbib@code\@empty

\newenvironment{theindex}
  {\if@twocolumn\@restonecolfalse\else\@restonecoltrue\fi
   \columnseprule\z@ \columnsep 35\p@
   \twocolumn[\section*{\indexname}]%
   \@mkboth{\indexname}{\indexname}%
   \thispagestyle{jpl@in}\parindent\z@
   \parskip\z@ \@plus .3\p@\relax
   \let\item\@idxitem}
  {\if@restonecol\onecolumn\else\clearpage\fi}
\newcommand{\@idxitem}{\par\hangindent 40\p@}
\newcommand{\subitem}{\@idxitem \hspace*{20\p@}}
\newcommand{\subsubitem}{\@idxitem \hspace*{30\p@}}
\newcommand{\indexspace}{\par \vskip 10\p@ \@plus5\p@ \@minus3\p@\relax}

\def\footnoterule{\kern-3\p@ 
 \hrule width \columnwidth 
 \kern 2.6\p@} 

%\renewcommand{\footnoterule}{%
%  \kern-3\p@
%  \hrule width .4\columnwidth
%  \kern 2.6\p@}

\long\def\@makefntext#1{\parindent 1zw\noindent 
 \hbox to 1.8em{\hss$^{\@thefnmark}$}#1}

%\newcommand\@makefntext[1]{\parindent 1em
%  \noindent\hbox to 1.8em{\hss\@makefnmark}#1}

\newif\if \false
\def\{\true}
\def\a{\false}
\newcount\heisei \heisei\year \advance\heisei-1988\relax
\def\today{{%
  \iftdir
    \if
      \kansuji\number\year N
      \kansuji\number\month 
      \kansuji\number\day 
    \else
      \ifnum\heisei=1 N\else\kansuji\number\heisei N\fi
      \kansuji\number\month 
      \kansuji\number\day 
    \fi
  \else
    \if
      \number\year~N
      \number\month~
      \number\day~
    \else
      \ifnum\heisei=1 N\else\number\heisei~N\fi
      \number\month~
      \number\day~
    \fi
  \fi}}
\newcommand{\prepartname}{}
\newcommand{\postpartname}{}
\newcommand{\contentsname}{ }
\newcommand{\listfigurename}{}  }
\newcommand{\listtablename}{\  }
\newcommand{\refname}{Ql}
\newcommand{\indexname}{ }
\newcommand{\figurename}{}}
\newcommand{\tablename}{\}
\newcommand{\appendixname}{t ^}
\newcommand{\abstractname}{T v}



%%% ̑̃}N
\def\onelineskip{\par\vspace{1\baselineskip}\par}
\def\halflineskip{\par\vspace{.5\baselineskip}\par}

%\def\kintou#1#2{%
% \leavevmode\hbox to #1{%
%  \kanjiskip\z@ plus 1fill minus 1fill\xkanjiskip\kanjiskip #2}}

%% LaTeX2e-type
\def\kintou#1#2{\@ifundefined{jintercharskip}%
 {\leavevmode\hbox to #1{%
   \kanjiskip\z@ \@plus 1fill \@minus 1fill\xkanjiskip\kanjiskip #2}}%
 {\leavevmode\hbox to #1{\jintercharskip\z@ \@plus 1fill \@minus 1fill
   \jasciikanjiskip\jintercharskip #2}}}

%% Hline
\def\Hline{\noalign{\hrule height 0.4mm}}


\def\MARU#1{\raisebox{0.1zh}{{\rm\ooalign{\hfil \lower.168ex\hbox{#1}\hfil\crcr\mathhexbox20D}}}}

\def\ruby#1#2{%
\leavevmode\vbox{\baselineskip\z@skip\lineskip.25ex
\ialign{##\crcr\tiny\hfill#1\hfill\crcr\hfill#2\hfill\crcr}}}

\def\doubledash{\leavevmode\hbox to 2zw{---\hss ---}}


\def\QED{{\unskip\nobreak\hfil\penalty50
 \hskip1zw\hbox{}\nobreak\hfil \hbox{$\Box$\hskip1zw}
 \parfillskip\z@ \finalhyphendemerits\z@\par}}

\def\AmSTeX{$\cal A\kern-.1667em\lower.5ex\hbox{$\cal M$}\kern-.125emS$-\TeX}
\def\AmSLaTeX{$\cal A\kern-.1667em\lower.5ex\hbox{$\cal M$}\kern-.125emS$-\LaTeX}


%%% o
%%\def\NOTICE{%
%%\vspace*{.5\baselineskip}
%%%\pagebreak[2]\vbox to 2\baselineskip{\vss\noindent{\bf }\vss}%
%%\nopagebreak\par{\small\@notice}\par}



%% Notice֘A
\newcounter{ccnotice}
\long\def\@Makefntext#1{\refstepcounter{ccnotice}%
\par%\vskip.1\baselineskip
\noindent{\<i\theccnoticej\<\hskip1.47zw#1}}
\def\notice#1{%
%%%%
\def\@makefnmark{{\bfi\@thefnmarkj}}
%%%%%
\long\gdef\@footnotetext##1{%\insert\footins{\footnotesize
    \interlinepenalty\interfootnotelinepenalty 
    \splittopskip\footnotesep
    \splitmaxdepth \dp\strutbox \floatingpenalty \@MM
    \hsize\columnwidth \@parboxrestore
   \edef\@currentlabel{\csname p@footnote\endcsname\@thefnmark}\@Makefntext
    {\rule{\z@}{\footnotesep}\ignorespaces
      \hangafter=1\hangindent=3zw##1\strut\par}}%}
%%%
\footnotemark\begingroup
\def\protect{\noexpand\protect\noexpand}\xdef\@notice{\@notice
  \protect\footnotetext[\the\c@footnote]{\protect#1}}\endgroup}

\def\NOTICE{%
%\vspace*{.5\baselineskip}
\pagebreak[2]\vbox to 2\baselineskip{\vss\noindent{\small{\bf }\par\vss}}%
\nopagebreak\par{\small\@notice}\par\unskip}
\def\@notice{}
%--------------------------------------





\newenvironment{Hangpar}[1]{\parindent=0zw\everypar{\hangafter=1\hangindent=#1}}{\par}

\newlength{\namelistindent}
\setlength{\namelistindent}{\z@}%% \parindent
\def\namelistlabel#1{\hspace\labelsep
\hspace\namelistindent \mbox{#1}\hfil}
%%%
\newenvironment{namelist}[1]{%
\parindent=0zw
\begin{list}{}{%
\settowidth{\labelwidth}{{#1 \hfil}}
\addtolength{\labelwidth}{\labelsep}
\addtolength{\labelwidth}{\namelistindent}
\setlength{\leftmargin}{\labelwidth}
\itemsep0pt\topsep0pt\parsep0pt
\let\makelabel\namelistlabel}}{%
\end{list}}

%%% from indent.sty
\newenvironment{indention}[1]%
{%
  \parindent\z@
  \setlength{\leftmargin}{#1}%
  \setlength{\rightmargin}{\z@}%
  \advance\linewidth -\leftmargin
  \advance\linewidth -\rightmargin
  \advance\@totalleftmargin\leftmargin
  \@setpar{{\@@par}}%
  \parshape 1 \@totalleftmargin \linewidth
  \ignorespaces
}%
{\par\noindent\global\@ignoretrue}




\def\HeikoTome{\ifvmode
   \GenericError{\space\space\space\@spaces\@spaces\@spaces}%
       {JSME package Error: You cannot use \string\Newpage in vertical mode}{the JSME package manual.}{\@eha}%
\fi%
\@ifnextchar[{\@HeikoTome}{\@HeikoTome[4.5mm]}}
\def\@HeikoTome[#1]{%
   \ifhmode
      \vadjust{\@Heiko@Tome{#1}}%
   \else
      \@Heiko@Tome{#1}%
   \fi
}%
\def\@Heiko@Tome#1{%
   \vskip#1
   \prevdepth-1000pt
\@tempdima\textwidth%
\advance\@tempdima-80mm%
\@tempdima.5\@tempdima%
%   \leavevmode\rlap{%
%      \hskip\@tempdima\vrule width80mm height.2pt depth.2pt}%
   \newpage
}

\let\Newpage\HeikoTome

\def\HeikoTomewithoutrule{%
\ifhmode
      \vadjust{\newpage}%
   \else
      \newpage%
   \fi
}%
\let\Newpagewithoutrule\HeikoTomewithoutrule



%%% \lastpage %%%
\def\lastpage@putlabel{\addtocounter{page}{-1}%
   \immediate\write\@auxout{\string
   \newlabel{LastPage}{{}{\thepage}}}%
   \addtocounter{page}{1}}
\AtEndDocument{%
   \message{AED: lastpage setting LastPage}%
   \clearpage\lastpage@putlabel}%




\def\sloppy{\tolerance9999\hbadness9999\hfuzz.5\p@ \vfuzz.5\p@}
\hbadness4000
\vbadness10001
\tolerance4000\pretolerance\m@ne
\clubpenalty\z@
\widowpenalty\z@
\displaywidowpenalty\z@
\interdisplaylinepenalty\z@ %%  100
\predisplaypenalty\z@       %% 1000

\pagenumbering{arabic}

\twocolumn
\sloppy
\flushbottom

\pagestyle{headings}

\AtBeginDvi{\special{papersize=182mm,257mm}}
\special{papersize=182mm,257mm}


%\if@twocolumn
%  \twocolumn
%  \sloppy
%  \flushbottom
%\else
%  \onecolumn
%\fi
%\if@twoside
%  \@mparswitchtrue
%\else
%  \@mparswitchfalse
%\fi
\endinput
%%
%% End of file `jarticle.cls'.
